/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;

public interface DownloadedContent
extends Serializable {
    public InputStream getInputStream() throws IOException;

    public void cleanUp();

    public boolean isEmpty();

    public long length();

    public static class InMemory
    implements DownloadedContent {
        private final byte[] bytes_;

        InMemory(byte[] byteArray) {
            this.bytes_ = byteArray == null ? ArrayUtils.EMPTY_BYTE_ARRAY : byteArray;
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.bytes_);
        }

        @Override
        public void cleanUp() {
        }

        @Override
        public boolean isEmpty() {
            return this.length() == 0L;
        }

        @Override
        public long length() {
            return this.bytes_.length;
        }
    }

    public static class OnFile
    implements DownloadedContent {
        private final File file_;
        private final boolean temporary_;

        OnFile(File file, boolean temporary) {
            this.file_ = file;
            this.temporary_ = temporary;
        }

        @Override
        public InputStream getInputStream() throws FileNotFoundException {
            return new FileInputStream(this.file_);
        }

        @Override
        public void cleanUp() {
            if (this.temporary_) {
                FileUtils.deleteQuietly(this.file_);
            }
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.cleanUp();
        }

        @Override
        public long length() {
            if (this.file_ == null) {
                return 0L;
            }
            return this.file_.length();
        }
    }
}

