/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.activex.javascript.msxml;

import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMDocument;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMDocumentFragment;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMElement;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMNode;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.NamedNodeMap;

public class XMLSerializer {
    private boolean preserveWhiteSpace_;

    public XMLSerializer(boolean preserveWhiteSpace) {
        this.preserveWhiteSpace_ = preserveWhiteSpace;
    }

    public String serializeToString(XMLDOMNode root) {
        if (root == null) {
            return "";
        }
        if (root instanceof XMLDOMDocument) {
            root = ((XMLDOMDocument)root).getDocumentElement();
        } else if (root instanceof XMLDOMDocumentFragment) {
            root = root.getFirstChild();
        }
        if (root instanceof XMLDOMElement) {
            StringBuilder builder = new StringBuilder();
            DomNode node = root.getDomNodeOrDie();
            this.toXml(1, node, builder);
            builder.append("\r\n");
            return builder.toString();
        }
        return root.getDomNodeOrDie().asXml();
    }

    private void toXml(int indent, DomNode node, StringBuilder builder) {
        String nodeName = node.getNodeName();
        builder.append('<').append(nodeName);
        String optionalPrefix = "";
        String namespaceURI = node.getNamespaceURI();
        String prefix = node.getPrefix();
        if (namespaceURI != null && prefix != null) {
            boolean sameNamespace = false;
            DomNode parentNode = node.getParentNode();
            while (parentNode instanceof DomElement) {
                if (namespaceURI.equals(parentNode.getNamespaceURI())) {
                    sameNamespace = true;
                }
                parentNode = parentNode.getParentNode();
            }
            if (node.getParentNode() == null || !sameNamespace) {
                ((DomElement)node).setAttribute("xmlns:" + prefix, namespaceURI);
            }
        }
        NamedNodeMap attributesMap = node.getAttributes();
        int i = 0;
        while (i < attributesMap.getLength()) {
            DomAttr attrib = (DomAttr)attributesMap.item(i);
            builder.append(' ').append(attrib.getQualifiedName()).append('=').append('\"').append(attrib.getValue()).append('\"');
            ++i;
        }
        boolean startTagClosed = false;
        block7: for (DomNode child : node.getChildren()) {
            if (!startTagClosed) {
                builder.append("").append('>');
                startTagClosed = true;
            }
            switch (child.getNodeType()) {
                case 1: {
                    this.toXml(indent + 1, child, builder);
                    break;
                }
                case 3: {
                    String value = child.getNodeValue();
                    value = com.gargoylesoftware.htmlunit.util.StringUtils.escapeXmlChars(value);
                    if (this.preserveWhiteSpace_) {
                        builder.append(value.replace("\n", "\r\n"));
                        break;
                    }
                    if (StringUtils.isBlank(value)) {
                        builder.append("\r\n");
                        DomNode sibling = child.getNextSibling();
                        if (sibling == null || sibling.getNodeType() != 1) continue block7;
                        int i2 = 0;
                        while (i2 < indent) {
                            builder.append('\t');
                            ++i2;
                        }
                        continue block7;
                    }
                    builder.append(value.replace("\n", "\r\n"));
                    break;
                }
                case 4: 
                case 8: {
                    if (!this.preserveWhiteSpace_ && builder.charAt(builder.length() - 1) == '\n') {
                        int i3 = 0;
                        while (i3 < indent) {
                            builder.append('\t');
                            ++i3;
                        }
                    }
                    builder.append(child.asXml());
                }
            }
        }
        if (!startTagClosed) {
            builder.append("").append("/>");
        } else {
            if (!this.preserveWhiteSpace_ && builder.charAt(builder.length() - 1) == '\n') {
                int i4 = 0;
                while (i4 < indent - 1) {
                    builder.append('\t');
                    ++i4;
                }
            }
            builder.append('<').append('/').append(nodeName).append('>');
        }
    }
}

