/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HtmlMap
extends HtmlElement {
    public static final String TAG_NAME = "map";

    HtmlMap(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE;
    }

    @Override
    public boolean isDisplayed() {
        HtmlImage image = this.findReferencingImage();
        if (image != null) {
            return image.isDisplayed();
        }
        return false;
    }

    private HtmlImage findReferencingImage() {
        HtmlPage page = this.getHtmlPageOrNull();
        String name = this.getNameAttribute();
        if (page != null && StringUtils.isNotBlank(name)) {
            name = "#" + name.trim();
            Iterator iterator = page.getDocumentElement().getElementsByTagName("img").iterator();
            while (iterator.hasNext()) {
                HtmlElement elem = (HtmlElement)iterator.next();
                HtmlImage image = (HtmlImage)elem;
                if (!name.equals(image.getUseMapAttribute())) continue;
                return image;
            }
        }
        return null;
    }
}

