/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html.applets;

import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AppletClassLoader
extends URLClassLoader {
    private static final Log LOG = LogFactory.getLog(AppletClassLoader.class);

    public AppletClassLoader(Window window) {
        super(new URL[0]);
        try {
            this.loadOurNetscapeStuff("netscape.javascript.JSException");
            Class<?> jsObjectClass = this.loadOurNetscapeStuff("netscape.javascript.JSObject");
            MethodUtils.invokeExactStaticMethod(jsObjectClass, "setWindow", window);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
    }

    public void addArchiveToClassPath(URL jarUrl) {
        this.addURL(jarUrl);
    }

    public void addClassToClassPath(String className, WebResponse webResponse) throws IOException {
        byte[] bytes = IOUtils.toByteArray(webResponse.getContentAsStream());
        this.defineClass(className, bytes, 0, bytes.length);
    }

    private Class<?> loadOurNetscapeStuff(String classNane) throws IOException {
        String myNetscapeClassName = String.valueOf(classNane.replace('.', '/')) + ".class";
        Enumeration<URL> locations = this.getClass().getClassLoader().getResources(myNetscapeClassName);
        URL myLocation = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        while (locations.hasMoreElements()) {
            URL pos = locations.nextElement();
            if (!pos.toExternalForm().contains(myLocation.toExternalForm())) continue;
            Throwable throwable = null;
            Object var7_8 = null;
            try (InputStream byteStream = pos.openStream();){
                byte[] bytes = IOUtils.toByteArray(byteStream);
                return this.defineClass(classNane, bytes, 0, bytes.length);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return null;
    }
}

