/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.configuration;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxStaticFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxStaticGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractJavaScriptConfiguration {
    private static final Log LOG = LogFactory.getLog(AbstractJavaScriptConfiguration.class);
    private static final Map<String, String> CLASS_NAME_MAP_ = new HashMap<String, String>();
    private Map<Class<?>, Class<? extends HtmlUnitScriptable>> domJavaScriptMap_;
    private final Map<String, ClassConfiguration> configuration_;

    protected AbstractJavaScriptConfiguration(BrowserVersion browser) {
        this.configuration_ = this.buildUsageMap(browser);
    }

    protected abstract Class<? extends SimpleScriptable>[] getClasses();

    public Iterable<ClassConfiguration> getAll() {
        return this.configuration_.values();
    }

    private Map<String, ClassConfiguration> buildUsageMap(BrowserVersion browser) {
        HashMap<String, ClassConfiguration> classMap = new HashMap<String, ClassConfiguration>(this.getClasses().length);
        Class<? extends SimpleScriptable>[] classArray = this.getClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends SimpleScriptable> klass = classArray[n2];
            ClassConfiguration config = AbstractJavaScriptConfiguration.getClassConfiguration(klass, browser);
            if (config != null) {
                classMap.put(config.getClassName(), config);
            }
            ++n2;
        }
        return Collections.unmodifiableMap(classMap);
    }

    public static ClassConfiguration getClassConfiguration(Class<? extends HtmlUnitScriptable> klass, BrowserVersion browser) {
        if (browser != null) {
            String expectedBrowserName = browser.isIE() ? "IE" : (browser.isFirefox() ? "FF" : (browser.isEdge() ? "EDGE" : "CHROME"));
            float browserVersionNumeric = browser.getBrowserVersionNumeric();
            String hostClassName = klass.getName();
            JsxClasses jsxClasses = klass.getAnnotation(JsxClasses.class);
            if (jsxClasses != null) {
                if (klass.getAnnotation(JsxClass.class) != null) {
                    throw new RuntimeException("Invalid JsxClasses/JsxClass annotation; class '" + hostClassName + "' has both.");
                }
                JsxClass[] jsxClassValues = jsxClasses.value();
                if (jsxClassValues.length == 1) {
                    throw new RuntimeException("No need to specify JsxClasses with a single JsxClass for " + hostClassName);
                }
                HashSet domClasses = new HashSet();
                boolean isJsObject = false;
                String className = null;
                int i = 0;
                while (i < jsxClassValues.length) {
                    JsxClass jsxClass = jsxClassValues[i];
                    if (jsxClass != null && AbstractJavaScriptConfiguration.isSupported(jsxClass.browsers(), expectedBrowserName, browserVersionNumeric)) {
                        domClasses.add(jsxClass.domClass());
                        if (jsxClass.isJSObject()) {
                            isJsObject = true;
                        }
                        if (!jsxClass.className().isEmpty()) {
                            className = jsxClass.className();
                        }
                    }
                    ++i;
                }
                ClassConfiguration classConfiguration = new ClassConfiguration(klass, domClasses.toArray(new Class[0]), isJsObject, className);
                AbstractJavaScriptConfiguration.process(classConfiguration, hostClassName, expectedBrowserName, browserVersionNumeric);
                return classConfiguration;
            }
            JsxClass jsxClass = klass.getAnnotation(JsxClass.class);
            if (jsxClass != null && AbstractJavaScriptConfiguration.isSupported(jsxClass.browsers(), expectedBrowserName, browserVersionNumeric)) {
                String className;
                HashSet domClasses = new HashSet();
                Class<?> domClass = jsxClass.domClass();
                if (domClass != null && domClass != Object.class) {
                    domClasses.add(domClass);
                }
                if ((className = jsxClass.className()).isEmpty()) {
                    className = null;
                }
                ClassConfiguration classConfiguration = new ClassConfiguration(klass, domClasses.toArray(new Class[0]), jsxClass.isJSObject(), className);
                AbstractJavaScriptConfiguration.process(classConfiguration, hostClassName, expectedBrowserName, browserVersionNumeric);
                return classConfiguration;
            }
        }
        return null;
    }

    private static void process(ClassConfiguration classConfiguration, String hostClassName, String expectedBrowserName, float browserVersionNumeric) {
        Annotation annotation;
        int n;
        int n2;
        Annotation[] annotationArray;
        String simpleClassName = hostClassName.substring(hostClassName.lastIndexOf(46) + 1);
        CLASS_NAME_MAP_.put(hostClassName, simpleClassName);
        HashMap<String, Executable> allGetters = new HashMap<String, Executable>();
        HashMap<String, Executable> allSetters = new HashMap<String, Executable>();
        AccessibleObject[] accessibleObjectArray = classConfiguration.getHostClass().getDeclaredConstructors();
        int n3 = accessibleObjectArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Constructor<?> constructor = accessibleObjectArray[n4];
            annotationArray = constructor.getAnnotations();
            n2 = annotationArray.length;
            n = 0;
            while (n < n2) {
                annotation = annotationArray[n];
                if (annotation instanceof JsxConstructor && AbstractJavaScriptConfiguration.isSupported(((JsxConstructor)annotation).value(), expectedBrowserName, browserVersionNumeric)) {
                    classConfiguration.setJSConstructor(constructor);
                }
                ++n;
            }
            ++n4;
        }
        accessibleObjectArray = classConfiguration.getHostClass().getDeclaredMethods();
        n3 = accessibleObjectArray.length;
        n4 = 0;
        while (n4 < n3) {
            Executable method = accessibleObjectArray[n4];
            annotationArray = method.getAnnotations();
            n2 = annotationArray.length;
            n = 0;
            while (n < n2) {
                annotation = annotationArray[n];
                if (annotation instanceof JsxGetter) {
                    JsxGetter jsxGetter = (JsxGetter)annotation;
                    if (AbstractJavaScriptConfiguration.isSupported(jsxGetter.value(), expectedBrowserName, browserVersionNumeric)) {
                        String property;
                        if (jsxGetter.propertyName().isEmpty()) {
                            int prefix = ((Method)method).getName().startsWith("is") ? 2 : 3;
                            property = ((Method)method).getName().substring(prefix);
                            property = String.valueOf(Character.toLowerCase(property.charAt(0))) + property.substring(1);
                        } else {
                            property = jsxGetter.propertyName();
                        }
                        allGetters.put(property, method);
                    }
                } else if (annotation instanceof JsxSetter) {
                    JsxSetter jsxSetter = (JsxSetter)annotation;
                    if (AbstractJavaScriptConfiguration.isSupported(jsxSetter.value(), expectedBrowserName, browserVersionNumeric)) {
                        String property;
                        if (jsxSetter.propertyName().isEmpty()) {
                            property = ((Method)method).getName().substring(3);
                            property = String.valueOf(Character.toLowerCase(property.charAt(0))) + property.substring(1);
                        } else {
                            property = jsxSetter.propertyName();
                        }
                        allSetters.put(property, method);
                    }
                } else if (annotation instanceof JsxFunction) {
                    JsxFunction jsxFunction = (JsxFunction)annotation;
                    if (AbstractJavaScriptConfiguration.isSupported(jsxFunction.value(), expectedBrowserName, browserVersionNumeric)) {
                        String name = jsxFunction.functionName().isEmpty() ? ((Method)method).getName() : jsxFunction.functionName();
                        classConfiguration.addFunction(name, (Method)method);
                    }
                } else if (annotation instanceof JsxStaticGetter) {
                    JsxStaticGetter jsxStaticGetter = (JsxStaticGetter)annotation;
                    if (AbstractJavaScriptConfiguration.isSupported(jsxStaticGetter.value(), expectedBrowserName, browserVersionNumeric)) {
                        int prefix = ((Method)method).getName().startsWith("is") ? 2 : 3;
                        String property = ((Method)method).getName().substring(prefix);
                        property = String.valueOf(Character.toLowerCase(property.charAt(0))) + property.substring(1);
                        classConfiguration.addStaticProperty(property, (Method)method, null);
                    }
                } else if (annotation instanceof JsxStaticFunction) {
                    JsxStaticFunction jsxStaticFunction = (JsxStaticFunction)annotation;
                    if (AbstractJavaScriptConfiguration.isSupported(jsxStaticFunction.value(), expectedBrowserName, browserVersionNumeric)) {
                        String name = jsxStaticFunction.functionName().isEmpty() ? ((Method)method).getName() : jsxStaticFunction.functionName();
                        classConfiguration.addStaticFunction(name, (Method)method);
                    }
                } else if (annotation instanceof JsxConstructor && AbstractJavaScriptConfiguration.isSupported(((JsxConstructor)annotation).value(), expectedBrowserName, browserVersionNumeric)) {
                    classConfiguration.setJSConstructor(method);
                }
                ++n;
            }
            ++n4;
        }
        accessibleObjectArray = classConfiguration.getHostClass().getDeclaredFields();
        n3 = accessibleObjectArray.length;
        n4 = 0;
        while (n4 < n3) {
            AccessibleObject field = accessibleObjectArray[n4];
            JsxConstant jsxConstant = ((Field)field).getAnnotation(JsxConstant.class);
            if (jsxConstant != null && AbstractJavaScriptConfiguration.isSupported(jsxConstant.value(), expectedBrowserName, browserVersionNumeric)) {
                classConfiguration.addConstant(((Field)field).getName());
            }
            ++n4;
        }
        for (Map.Entry getterEntry : allGetters.entrySet()) {
            String property = (String)getterEntry.getKey();
            classConfiguration.addProperty(property, (Method)getterEntry.getValue(), (Method)allSetters.get(property));
        }
    }

    private static boolean isSupported(WebBrowser[] browsers, String expectedBrowserName, float expectedVersionNumeric) {
        WebBrowser[] webBrowserArray = browsers;
        int n = browsers.length;
        int n2 = 0;
        while (n2 < n) {
            WebBrowser browser = webBrowserArray[n2];
            if (browser.value().name().equals(expectedBrowserName) && (float)browser.minVersion() <= expectedVersionNumeric && (float)browser.maxVersion() >= expectedVersionNumeric) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public ClassConfiguration getClassConfiguration(String hostClassName) {
        return this.configuration_.get(hostClassName);
    }

    public Map<Class<?>, Class<? extends HtmlUnitScriptable>> getDomJavaScriptMapping() {
        if (this.domJavaScriptMap_ != null) {
            return this.domJavaScriptMap_;
        }
        HashMap map = new HashMap(this.configuration_.size());
        boolean debug = LOG.isDebugEnabled();
        for (String hostClassName : this.configuration_.keySet()) {
            ClassConfiguration classConfig = this.getClassConfiguration(hostClassName);
            Class<?>[] classArray = classConfig.getDomClasses();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> domClass = classArray[n2];
                if (debug) {
                    LOG.debug("Mapping " + domClass.getName() + " to " + hostClassName);
                }
                map.put(domClass, classConfig.getHostClass());
                ++n2;
            }
        }
        this.domJavaScriptMap_ = Collections.unmodifiableMap(map);
        return this.domJavaScriptMap_;
    }
}

