/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import com.gargoylesoftware.htmlunit.javascript.host.event.MessageEvent;
import java.net.URL;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.Function;

@JsxClass
public class MessagePort
extends EventTarget {
    private MessagePort port1_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public MessagePort() {
    }

    public MessagePort(MessagePort port1) {
        this.port1_ = port1;
    }

    @JsxGetter
    public Object getOnmessage() {
        return this.getHandlerForJavaScript("message");
    }

    @JsxSetter
    public void setOnmessage(Object onmessage) {
        this.setHandlerForJavaScript("message", onmessage);
    }

    private Object getHandlerForJavaScript(String eventName) {
        return this.getEventListenersContainer().getEventHandlerProp(eventName);
    }

    private void setHandlerForJavaScript(String eventName, Object handler) {
        if (handler == null || handler instanceof Function) {
            this.getEventListenersContainer().setEventHandlerProp(eventName, handler);
        }
    }

    @JsxFunction
    public void postMessage(String message, Object transfer) {
        if (this.port1_ != null) {
            URL currentURL = this.getWindow().getWebWindow().getEnclosedPage().getUrl();
            final MessageEvent event = new MessageEvent();
            String origin = String.valueOf(currentURL.getProtocol()) + "://" + currentURL.getHost() + ':' + currentURL.getPort();
            event.initMessageEvent("message", false, false, message, origin, "", this.getWindow(), transfer);
            event.setParentScope(this.port1_);
            event.setPrototype(this.getPrototype(event.getClass()));
            final JavaScriptEngine jsEngine = this.getWindow().getWebWindow().getWebClient().getJavaScriptEngine();
            PostponedAction action = new PostponedAction(this.getWindow().getWebWindow().getEnclosedPage()){

                @Override
                public void execute() throws Exception {
                    ContextAction contextAction = new ContextAction(){

                        @Override
                        public Object run(Context cx) {
                            return MessagePort.this.port1_.dispatchEvent(event);
                        }
                    };
                    HtmlUnitContextFactory cf = jsEngine.getContextFactory();
                    cf.call(contextAction);
                }
            };
            jsEngine.addPostponedAction(action);
        }
    }
}

