/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import com.gargoylesoftware.htmlunit.javascript.host.html.FormField;
import com.gargoylesoftware.htmlunit.javascript.host.html.LabelsHelper;
import net.sourceforge.htmlunit.corejs.javascript.Context;

@JsxClass(domClass=HtmlTextArea.class)
public class HTMLTextAreaElement
extends FormField {
    private AbstractList labels_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public HTMLTextAreaElement() {
    }

    @JsxGetter
    public String getType() {
        return "textarea";
    }

    @Override
    public String getValue() {
        return ((HtmlTextArea)this.getDomNodeOrDie()).getText();
    }

    @Override
    public void setValue(Object value) {
        if (value == null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TEXT_AREA_SET_VALUE_NULL)) {
            ((HtmlTextArea)this.getDomNodeOrDie()).setText("");
            return;
        }
        ((HtmlTextArea)this.getDomNodeOrDie()).setText(Context.toString(value));
    }

    @JsxGetter
    public int getCols() {
        String s = this.getDomNodeOrDie().getAttribute("cols");
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 20;
        }
    }

    @JsxSetter
    public void setCols(String cols) {
        try {
            int i = Float.valueOf(cols).intValue();
            if (i < 0) {
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TEXT_AREA_SET_COLS_NEGATIVE_THROWS_EXCEPTION)) {
                    throw new NumberFormatException("New value for cols '" + cols + "' is smaller than zero.");
                }
                this.getDomNodeOrDie().setAttribute("cols", null);
                return;
            }
            this.getDomNodeOrDie().setAttribute("cols", Integer.toString(i));
        }
        catch (NumberFormatException e) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TEXT_AREA_SET_COLS_THROWS_EXCEPTION)) {
                throw Context.throwAsScriptRuntimeEx(e);
            }
            this.getDomNodeOrDie().setAttribute("cols", "20");
        }
    }

    @JsxGetter
    public int getRows() {
        String s = this.getDomNodeOrDie().getAttribute("rows");
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 2;
        }
    }

    @JsxSetter
    public void setRows(String rows) {
        try {
            int i = new Float(rows).intValue();
            if (i < 0) {
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TEXT_AREA_SET_ROWS_NEGATIVE_THROWS_EXCEPTION)) {
                    throw new NumberFormatException("New value for rows '" + rows + "' is smaller than zero.");
                }
                this.getDomNodeOrDie().setAttribute("rows", null);
                return;
            }
            this.getDomNodeOrDie().setAttribute("rows", Integer.toString(i));
        }
        catch (NumberFormatException e) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TEXT_AREA_SET_ROWS_THROWS_EXCEPTION)) {
                throw Context.throwAsScriptRuntimeEx(e);
            }
            this.getDomNodeOrDie().setAttribute("rows", "2");
        }
    }

    @JsxGetter
    public String getDefaultValue() {
        return ((HtmlTextArea)this.getDomNodeOrDie()).getDefaultValue();
    }

    @JsxSetter
    public void setDefaultValue(String defaultValue) {
        ((HtmlTextArea)this.getDomNodeOrDie()).setDefaultValue(defaultValue);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public int getTextLength() {
        return this.getValue().length();
    }

    @JsxGetter
    public int getSelectionStart() {
        return ((HtmlTextArea)this.getDomNodeOrDie()).getSelectionStart();
    }

    @JsxSetter
    public void setSelectionStart(int start) {
        ((HtmlTextArea)this.getDomNodeOrDie()).setSelectionStart(start);
    }

    @JsxGetter
    public int getSelectionEnd() {
        return ((HtmlTextArea)this.getDomNodeOrDie()).getSelectionEnd();
    }

    @JsxSetter
    public void setSelectionEnd(int end) {
        ((HtmlTextArea)this.getDomNodeOrDie()).setSelectionEnd(end);
    }

    @JsxFunction
    public void setSelectionRange(int start, int end) {
        this.setSelectionStart(start);
        this.setSelectionEnd(end);
    }

    @JsxFunction
    public void select() {
        ((HtmlTextArea)this.getDomNodeOrDie()).select();
    }

    @JsxGetter
    public boolean getReadOnly() {
        return ((HtmlTextArea)this.getDomNodeOrDie()).isReadOnly();
    }

    @JsxSetter
    public void setReadOnly(boolean readOnly) {
        ((HtmlTextArea)this.getDomNodeOrDie()).setReadOnly(readOnly);
    }

    @JsxGetter
    public Object getMaxLength() {
        String maxLength = this.getDomNodeOrDie().getAttribute("maxLength");
        try {
            return Integer.parseInt(maxLength);
        }
        catch (NumberFormatException e) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TEXT_AREA_GET_MAXLENGTH_MAX_INT)) {
                return Integer.MAX_VALUE;
            }
            return -1;
        }
    }

    @JsxSetter
    public void setMaxLength(String maxLength) {
        try {
            int i = Integer.parseInt(maxLength);
            if (i < 0 && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TEXT_AREA_SET_MAXLENGTH_NEGATIVE_THROWS_EXCEPTION)) {
                throw Context.throwAsScriptRuntimeEx(new NumberFormatException("New value for maxLength '" + maxLength + "' is smaller than zero."));
            }
            this.getDomNodeOrDie().setAttribute("maxLength", maxLength);
        }
        catch (NumberFormatException e) {
            this.getDomNodeOrDie().setAttribute("maxLength", "0");
            return;
        }
    }

    @JsxGetter
    public String getPlaceholder() {
        return ((HtmlTextArea)this.getDomNodeOrDie()).getPlaceholder();
    }

    @JsxSetter
    public void setPlaceholder(String placeholder) {
        ((HtmlTextArea)this.getDomNodeOrDie()).setPlaceholder(placeholder);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME)})
    public AbstractList getLabels() {
        if (this.labels_ == null) {
            this.labels_ = new LabelsHelper(this.getDomNodeOrDie());
        }
        return this.labels_;
    }
}

