/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlUnknownElement;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.xml.XmlPage;

@JsxClass(domClass=HtmlUnknownElement.class)
public class HTMLUnknownElement
extends HTMLElement {
    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public HTMLUnknownElement() {
    }

    @Override
    public String getNodeName() {
        HtmlElement elem = this.getDomNodeOrDie();
        SgmlPage page = elem.getPage();
        if (page instanceof XmlPage) {
            return elem.getLocalName();
        }
        return super.getNodeName();
    }

    @Override
    public String getClassName() {
        HtmlElement element;
        if (this.getWindow().getWebWindow() != null && (element = this.getDomNodeOrNull()) != null) {
            String name = element.getNodeName();
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_HTML_RUBY_ELEMENT_CLASS_NAME) && ("rp".equals(name) || "rt".equals(name) || "ruby".equals(name) || "rb".equals(name) || "rtc".equals(name))) {
                return "HTMLElement";
            }
            if (name.indexOf(45) != -1 && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_HTML_HYPHEN_ELEMENT_CLASS_NAME)) {
                return "HTMLElement";
            }
        }
        return super.getClassName();
    }

    @Override
    protected boolean isLowerCaseInOuterHtml() {
        return true;
    }

    @Override
    protected boolean isEndTagForbidden() {
        if ("IMAGE".equals(this.getNodeName())) {
            return true;
        }
        return super.isEndTagForbidden();
    }
}

