/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.xml;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomCDataSection;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomDocumentType;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomProcessingInstruction;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.ElementFactory;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DeferredNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public final class XmlUtil {
    @Deprecated
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Log LOG = LogFactory.getLog(XmlUtil.class);
    private static final ErrorHandler DISCARD_MESSAGES_HANDLER = new ErrorHandler(){

        @Override
        public void error(SAXParseException exception) {
        }

        @Override
        public void fatalError(SAXParseException exception) {
        }

        @Override
        public void warning(SAXParseException exception) {
        }
    };

    private XmlUtil() {
    }

    public static Document buildDocument(WebResponse webResponse) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        if (webResponse == null) {
            return factory.newDocumentBuilder().newDocument();
        }
        factory.setNamespaceAware(true);
        InputStreamReader reader = new InputStreamReader((InputStream)new BOMInputStream(webResponse.getContentAsStream()), webResponse.getContentCharset());
        TrackBlankContentReader tracker = new TrackBlankContentReader(reader);
        InputSource source = new InputSource(tracker);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(DISCARD_MESSAGES_HANDLER);
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        try {
            return builder.parse(source);
        }
        catch (SAXException e) {
            if (tracker.wasBlank()) {
                return factory.newDocumentBuilder().newDocument();
            }
            throw e;
        }
    }

    public static void appendChild(SgmlPage page, DomNode parent, Node child, boolean handleXHTMLAsHTML) {
        XmlUtil.appendChild(page, parent, child, handleXHTMLAsHTML, null);
    }

    public static void appendChild(SgmlPage page, DomNode parent, Node child, boolean handleXHTMLAsHTML, Map<Integer, List<String>> attributesOrderMap) {
        DocumentType documentType = child.getOwnerDocument().getDoctype();
        if (documentType != null && page instanceof XmlPage) {
            DomDocumentType domDoctype = new DomDocumentType(page, documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
            ((XmlPage)page).setDocumentType(domDoctype);
        }
        DomNode childXml = XmlUtil.createFrom(page, child, handleXHTMLAsHTML, attributesOrderMap);
        parent.appendChild(childXml);
        XmlUtil.copy(page, child, childXml, handleXHTMLAsHTML, attributesOrderMap);
    }

    private static DomNode createFrom(SgmlPage page, Node source, boolean handleXHTMLAsHTML, Map<Integer, List<String>> attributesOrderMap) {
        if (source.getNodeType() == 3) {
            return new DomText(page, source.getNodeValue());
        }
        if (source.getNodeType() == 7) {
            return new DomProcessingInstruction(page, source.getNodeName(), source.getNodeValue());
        }
        if (source.getNodeType() == 8) {
            return new DomComment(page, source.getNodeValue());
        }
        if (source.getNodeType() == 10) {
            DocumentType documentType = (DocumentType)source;
            return new DomDocumentType(page, documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
        }
        String ns = source.getNamespaceURI();
        String localName = source.getLocalName();
        if (handleXHTMLAsHTML && "http://www.w3.org/1999/xhtml".equals(ns)) {
            ElementFactory factory = HTMLParser.getFactory(localName);
            return factory.createElementNS(page, ns, localName, XmlUtil.namedNodeMapToSaxAttributes(source.getAttributes(), attributesOrderMap, source));
        }
        NamedNodeMap nodeAttributes = source.getAttributes();
        if (page != null && page.isHtmlPage()) {
            localName = localName.toUpperCase(Locale.ROOT);
        }
        String qualifiedName = source.getPrefix() == null ? localName : String.valueOf(source.getPrefix()) + ':' + localName;
        String namespaceURI = source.getNamespaceURI();
        if ("http://www.w3.org/2000/svg".equals(namespaceURI)) {
            return HTMLParser.SVG_FACTORY.createElementNS(page, namespaceURI, qualifiedName, XmlUtil.namedNodeMapToSaxAttributes(nodeAttributes, attributesOrderMap, source));
        }
        LinkedHashMap<String, DomAttr> attributes = new LinkedHashMap<String, DomAttr>();
        int i = 0;
        while (i < nodeAttributes.getLength()) {
            int orderedIndex = XmlUtil.getIndex(nodeAttributes, attributesOrderMap, source, i);
            Attr attribute = (Attr)nodeAttributes.item(orderedIndex);
            String attributeNamespaceURI = attribute.getNamespaceURI();
            String attributeQualifiedName = attribute.getPrefix() != null ? String.valueOf(attribute.getPrefix()) + ':' + attribute.getLocalName() : attribute.getLocalName();
            String value = attribute.getNodeValue();
            boolean specified = attribute.getSpecified();
            DomAttr xmlAttribute = new DomAttr(page, attributeNamespaceURI, attributeQualifiedName, value, specified);
            attributes.put(attribute.getNodeName(), xmlAttribute);
            ++i;
        }
        return new DomElement(namespaceURI, qualifiedName, page, attributes);
    }

    private static Attributes namedNodeMapToSaxAttributes(NamedNodeMap attributesMap, Map<Integer, List<String>> attributesOrderMap, Node element) {
        AttributesImpl attributes = new AttributesImpl();
        int length = attributesMap.getLength();
        int i = 0;
        while (i < length) {
            int orderedIndex = XmlUtil.getIndex(attributesMap, attributesOrderMap, element, i);
            Node attr = attributesMap.item(orderedIndex);
            attributes.addAttribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getNodeName(), null, attr.getNodeValue());
            ++i;
        }
        return attributes;
    }

    private static int getIndex(NamedNodeMap namedNodeMap, Map<Integer, List<String>> attributesOrderMap, Node element, int requiredIndex) {
        int elementIndex;
        List<String> attributesOrderList;
        if (attributesOrderMap != null && element instanceof DeferredNode && (attributesOrderList = attributesOrderMap.get(elementIndex = ((DeferredNode)element).getNodeIndex())) != null) {
            String attributeName = attributesOrderList.get(requiredIndex);
            int i = 0;
            while (i < namedNodeMap.getLength()) {
                if (namedNodeMap.item(i).getNodeName().equals(attributeName)) {
                    return i;
                }
                ++i;
            }
        }
        return requiredIndex;
    }

    private static void copy(SgmlPage page, Node source, DomNode dest, boolean handleXHTMLAsHTML, Map<Integer, List<String>> attributesOrderMap) {
        NodeList nodeChildren = source.getChildNodes();
        int i = 0;
        while (i < nodeChildren.getLength()) {
            Node child = nodeChildren.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    DomNode childXml = XmlUtil.createFrom(page, child, handleXHTMLAsHTML, attributesOrderMap);
                    dest.appendChild(childXml);
                    XmlUtil.copy(page, child, childXml, handleXHTMLAsHTML, attributesOrderMap);
                    break;
                }
                case 3: {
                    dest.appendChild(new DomText(page, child.getNodeValue()));
                    break;
                }
                case 4: {
                    dest.appendChild(new DomCDataSection(page, child.getNodeValue()));
                    break;
                }
                case 8: {
                    dest.appendChild(new DomComment(page, child.getNodeValue()));
                    break;
                }
                case 7: {
                    dest.appendChild(new DomProcessingInstruction(page, child.getNodeName(), child.getNodeValue()));
                    break;
                }
                default: {
                    LOG.warn("NodeType " + child.getNodeType() + " (" + child.getNodeName() + ") is not yet supported.");
                }
            }
            ++i;
        }
    }

    public static String lookupNamespaceURI(DomElement element, String prefix) {
        DomNode parentNode;
        String uri = DomElement.ATTRIBUTE_NOT_DEFINED;
        uri = prefix.isEmpty() ? element.getAttribute("xmlns") : element.getAttribute("xmlns:" + prefix);
        if (uri == DomElement.ATTRIBUTE_NOT_DEFINED && (parentNode = element.getParentNode()) instanceof DomElement) {
            uri = XmlUtil.lookupNamespaceURI((DomElement)parentNode, prefix);
        }
        return uri;
    }

    public static String lookupPrefix(DomElement element, String namespace) {
        Map<String, DomAttr> attributes = element.getAttributesMap();
        for (Map.Entry<String, DomAttr> entry : attributes.entrySet()) {
            String name = entry.getKey();
            DomAttr value = entry.getValue();
            if (!name.startsWith("xmlns:") || !value.getValue().equals(namespace)) continue;
            return name.substring(6);
        }
        for (DomNode child : element.getChildren()) {
            String prefix;
            if (!(child instanceof DomElement) || (prefix = XmlUtil.lookupPrefix((DomElement)child, namespace)) == null) continue;
            return prefix;
        }
        return null;
    }

    public static Map<Integer, List<String>> getAttributesOrderMap(Document document) {
        HashMap<Integer, List<String>> map = new HashMap<Integer, List<String>>();
        if (document instanceof DeferredDocumentImpl) {
            DeferredDocumentImpl deferredDocument = (DeferredDocumentImpl)document;
            int fNodeCount = (Integer)XmlUtil.getPrivate(deferredDocument, "fNodeCount");
            int i = 0;
            while (i < fNodeCount) {
                short type = deferredDocument.getNodeType(i, false);
                if (type == 1) {
                    int attrIndex = deferredDocument.getNodeExtra(i, false);
                    ArrayList<String> attributes = new ArrayList<String>();
                    map.put(i, attributes);
                    while (attrIndex != -1) {
                        attributes.add(deferredDocument.getNodeName(attrIndex, false));
                        attrIndex = deferredDocument.getPrevSibling(attrIndex, false);
                    }
                }
                ++i;
            }
        }
        return map;
    }

    private static <T> T getPrivate(Object object, String fieldName) {
        try {
            Field f = object.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            return (T)f.get(object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static final class TrackBlankContentReader
    extends Reader {
        private Reader reader_;
        private boolean wasBlank_ = true;

        TrackBlankContentReader(Reader characterStream) {
            this.reader_ = characterStream;
        }

        public boolean wasBlank() {
            return this.wasBlank_;
        }

        @Override
        public void close() throws IOException {
            this.reader_.close();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int result = this.reader_.read(cbuf, off, len);
            if (this.wasBlank_ && result > -1) {
                int i = 0;
                while (i < result) {
                    char ch = cbuf[off + i];
                    if (!Character.isWhitespace(ch)) {
                        this.wasBlank_ = false;
                        break;
                    }
                    ++i;
                }
            }
            return result;
        }
    }
}

