/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.Executable;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.os.ExecutableFinder;
import org.openqa.selenium.os.WindowsUtils;

public class FirefoxBinary {
    private static final String NO_FOCUS_LIBRARY_NAME = "x_ignore_nofocus.so";
    private static final String PATH_PREFIX = "/" + FirefoxBinary.class.getPackage().getName().replace(".", "/") + "/";
    private final Map<String, String> extraEnv = Maps.newHashMap();
    private final List<String> extraOptions = Lists.newArrayList();
    private final Executable executable;
    private CommandLine process;
    private OutputStream stream;
    private long timeout = TimeUnit.SECONDS.toMillis(45L);

    public FirefoxBinary() {
        Executable systemBinary = FirefoxBinary.locateFirefoxBinaryFromSystemProperty();
        if (systemBinary != null) {
            this.executable = systemBinary;
            return;
        }
        Executable platformBinary = FirefoxBinary.locateFirefoxBinariesFromPlatform().findFirst().orElse(null);
        if (platformBinary != null) {
            this.executable = platformBinary;
            return;
        }
        throw new WebDriverException("Cannot find firefox binary in PATH. Make sure firefox is installed. OS appears to be: " + (Object)((Object)Platform.getCurrent()));
    }

    public FirefoxBinary(Channel channel) {
        Executable systemBinary = FirefoxBinary.locateFirefoxBinaryFromSystemProperty();
        if (systemBinary != null) {
            if (systemBinary.getChannel() == channel) {
                this.executable = systemBinary;
                return;
            }
            throw new WebDriverException("Firefox executable specified by system property webdriver.firefox.bin does not belong to channel '" + (Object)((Object)channel) + "', it appears to be '" + (Object)((Object)systemBinary.getChannel()) + "'");
        }
        this.executable = FirefoxBinary.locateFirefoxBinariesFromPlatform().filter(e -> e.getChannel() == channel).findFirst().orElseThrow(() -> new WebDriverException(String.format("Cannot find firefox binary for channel '%s' in PATH", new Object[]{channel})));
    }

    public FirefoxBinary(File pathToFirefoxBinary) {
        this.executable = new Executable(pathToFirefoxBinary);
    }

    public void setEnvironmentProperty(String propertyName, String value) {
        if (propertyName == null || value == null) {
            throw new WebDriverException(String.format("You must set both the property name and value: %s, %s", propertyName, value));
        }
        this.extraEnv.put(propertyName, value);
    }

    public void addCommandLineOptions(String ... options) {
        this.extraOptions.addAll(Lists.newArrayList(options));
    }

    void amendOptions(FirefoxOptions options) {
        options.addArguments(this.extraOptions);
    }

    protected boolean isOnLinux() {
        return Platform.getCurrent().is(Platform.LINUX);
    }

    public void startProfile(FirefoxProfile profile, File profileDir, String ... commandLineFlags) throws IOException {
        String profileAbsPath = profileDir.getAbsolutePath();
        this.setEnvironmentProperty("XRE_PROFILE_PATH", profileAbsPath);
        this.setEnvironmentProperty("MOZ_NO_REMOTE", "1");
        this.setEnvironmentProperty("MOZ_CRASHREPORTER_DISABLE", "1");
        this.setEnvironmentProperty("NO_EM_RESTART", "1");
        if (this.isOnLinux() && profile.shouldLoadNoFocusLib()) {
            this.modifyLinkLibraryPath(profileDir);
        }
        ArrayList<String> cmdArray = Lists.newArrayList();
        cmdArray.addAll(this.extraOptions);
        cmdArray.addAll(Lists.newArrayList(commandLineFlags));
        CommandLine command = new CommandLine(this.getPath(), Iterables.toArray(cmdArray, String.class));
        command.setEnvironmentVariables(this.getExtraEnv());
        command.updateDynamicLibraryPath(this.getExtraEnv().get(CommandLine.getLibraryPathPropertyName()));
        if (!Platform.getCurrent().is(Platform.MAC) || Platform.getCurrent().getMinorVersion() <= 5) {
            String firefoxLibraryPath = System.getProperty("webdriver.firefox.library.path", this.getFile().getAbsoluteFile().getParentFile().getAbsolutePath());
            command.updateDynamicLibraryPath(firefoxLibraryPath);
        }
        if (this.stream == null) {
            this.stream = this.getDefaultOutputStream();
        }
        command.copyOutputTo(this.stream);
        this.startFirefoxProcess(command);
    }

    protected void startFirefoxProcess(CommandLine command) throws IOException {
        this.process = command;
        command.executeAsync();
    }

    protected File getFile() {
        return this.executable.getFile();
    }

    protected String getPath() {
        return this.executable.getPath();
    }

    public Map<String, String> getExtraEnv() {
        return Collections.unmodifiableMap(this.extraEnv);
    }

    protected void modifyLinkLibraryPath(File profileDir) {
        String existingLdLibPath = System.getenv("LD_LIBRARY_PATH");
        String newLdLibPath = this.extractAndCheck(profileDir, NO_FOCUS_LIBRARY_NAME, PATH_PREFIX + "x86", PATH_PREFIX + "amd64");
        if (existingLdLibPath != null && !existingLdLibPath.equals("")) {
            newLdLibPath = newLdLibPath + existingLdLibPath;
        }
        this.setEnvironmentProperty("LD_LIBRARY_PATH", newLdLibPath);
        this.setEnvironmentProperty("LD_PRELOAD", NO_FOCUS_LIBRARY_NAME);
    }

    protected String extractAndCheck(File profileDir, String noFocusSoName, String jarPath32Bit, String jarPath64Bit) {
        HashSet<String> pathsSet = new HashSet<String>();
        pathsSet.add(jarPath32Bit);
        pathsSet.add(jarPath64Bit);
        StringBuilder builtPath = new StringBuilder();
        for (String path : pathsSet) {
            try {
                FileHandler.copyResource(profileDir, this.getClass(), path + File.separator + noFocusSoName);
            }
            catch (IOException e) {
                if (Boolean.getBoolean("webdriver.development")) {
                    System.err.println("Exception unpacking required library, but in development mode. Continuing");
                }
                throw new WebDriverException(e);
            }
            String outSoPath = profileDir.getAbsolutePath() + File.separator + path;
            File file = new File(outSoPath, noFocusSoName);
            if (!file.exists()) {
                throw new WebDriverException("Could not locate " + path + ": native events will not work.");
            }
            builtPath.append(outSoPath).append(":");
        }
        return builtPath.toString();
    }

    public void waitFor() throws InterruptedException, IOException {
        this.process.waitFor();
    }

    public void waitFor(long timeout) throws InterruptedException, IOException {
        this.process.waitFor(timeout);
    }

    public String getConsoleOutput() throws IOException {
        if (this.process == null) {
            return null;
        }
        return this.process.getStdOut();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return "FirefoxBinary(" + this.executable.getPath() + ")";
    }

    public void setOutputWatcher(OutputStream stream) {
        this.stream = stream;
    }

    public void quit() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    private OutputStream getDefaultOutputStream() throws FileNotFoundException {
        String firefoxLogFile = System.getProperty("webdriver.firefox.logfile");
        if (firefoxLogFile != null) {
            if ("/dev/stdout".equals(firefoxLogFile)) {
                return System.out;
            }
            return new FileOutputStream(firefoxLogFile);
        }
        return null;
    }

    private static Executable locateFirefoxBinaryFromSystemProperty() {
        String binaryName = System.getProperty("webdriver.firefox.bin");
        if (binaryName == null) {
            return null;
        }
        File binary = new File(binaryName);
        if (binary.exists() && !binary.isDirectory()) {
            return new Executable(binary);
        }
        Platform current = Platform.getCurrent();
        if (current.is(Platform.WINDOWS)) {
            if (!binaryName.endsWith(".exe")) {
                binaryName = binaryName + ".exe";
            }
        } else if (current.is(Platform.MAC)) {
            if (!binaryName.endsWith(".app")) {
                binaryName = binaryName + ".app";
            }
            binaryName = binaryName + "/Contents/MacOS/firefox-bin";
        }
        if ((binary = new File(binaryName)).exists()) {
            return new Executable(binary);
        }
        throw new WebDriverException(String.format("'%s' property set, but unable to locate the requested binary: %s", "webdriver.firefox.bin", binaryName));
    }

    private static Stream<Executable> locateFirefoxBinariesFromPlatform() {
        String systemFirefoxBin;
        ImmutableList.Builder executables = new ImmutableList.Builder();
        Platform current = Platform.getCurrent();
        if (current.is(Platform.WINDOWS)) {
            executables.addAll((Iterable)Stream.of(WindowsUtils.getPathsInProgramFiles("Mozilla Firefox\\firefox.exe"), WindowsUtils.getPathsInProgramFiles("Firefox Developer Edition\\firefox.exe"), WindowsUtils.getPathsInProgramFiles("Nightly\\firefox.exe")).flatMap(Collection::stream).map(File::new).filter(File::exists).map(Executable::new).collect(Collectors.toList()));
        } else if (current.is(Platform.MAC)) {
            File binary = new File("/Applications/Firefox.app/Contents/MacOS/firefox-bin");
            if (binary.exists()) {
                executables.add(new Executable(binary));
            }
            if ((binary = new File(System.getProperty("user.home") + binary.getAbsolutePath())).exists()) {
                executables.add(new Executable(binary));
            }
        } else if (current.is(Platform.UNIX) && (systemFirefoxBin = new ExecutableFinder().find("firefox-bin")) != null) {
            executables.add(new Executable(new File(systemFirefoxBin)));
        }
        String systemFirefox = new ExecutableFinder().find("firefox");
        if (systemFirefox != null) {
            Path firefoxPath = new File(systemFirefox).toPath();
            if (Files.isSymbolicLink(firefoxPath)) {
                try {
                    Path realPath = firefoxPath.toRealPath(new LinkOption[0]);
                    File attempt1 = realPath.getParent().resolve("firefox").toFile();
                    if (attempt1.exists()) {
                        executables.add(new Executable(attempt1));
                    } else {
                        File attempt2 = realPath.getParent().resolve("firefox-bin").toFile();
                        if (attempt2.exists()) {
                            executables.add(new Executable(attempt2));
                        }
                    }
                }
                catch (IOException iOException) {}
            } else {
                executables.add(new Executable(new File(systemFirefox)));
            }
        }
        return executables.build().stream();
    }

    public static enum Channel {
        ESR("esr"),
        RELEASE("release"),
        BETA("beta"),
        AURORA("aurora"),
        NIGHTLY("nightly");

        private String name;

        private Channel(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Channel fromString(String name) {
            String lcName = name.toLowerCase();
            return Arrays.stream(Channel.values()).filter(ch -> ch.name.equals(lcName)).findFirst().orElseThrow(() -> new WebDriverException("Unrecognized channel: " + name));
        }
    }
}

