/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.firefox.XpiDriverService;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.remote.service.DriverService;

public class FirefoxDriver
extends RemoteWebDriver {
    private static final Logger LOG = Logger.getLogger(FirefoxDriver.class.getName());
    public static final String BINARY = "firefox_binary";
    public static final String PROFILE = "firefox_profile";
    public static final String MARIONETTE = "marionette";
    protected FirefoxBinary binary;

    public FirefoxDriver() {
        this(new FirefoxOptions());
    }

    public FirefoxDriver(FirefoxOptions options) {
        this(FirefoxDriver.toExecutor(options), options.toCapabilities(), options.toCapabilities());
    }

    @Deprecated
    public FirefoxDriver(FirefoxBinary binary) {
        this(new FirefoxOptions().setBinary(binary));
        this.warnAboutDeprecatedConstructor("FirefoxBinary", "setBinary(binary)");
    }

    public FirefoxDriver(FirefoxProfile profile) {
        this(new FirefoxOptions().setProfile(profile));
    }

    @Deprecated
    public FirefoxDriver(FirefoxBinary binary, FirefoxProfile profile) {
        this(new FirefoxOptions().setBinary(binary).setProfile(profile));
        this.warnAboutDeprecatedConstructor("FirefoxBinary and FirefoxProfile", "setBinary(binary).setProfile(profile)");
    }

    public FirefoxDriver(Capabilities desiredCapabilities) {
        this(FirefoxDriver.getFirefoxOptions(desiredCapabilities).addCapabilities(desiredCapabilities));
    }

    @Deprecated
    public FirefoxDriver(Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        this(FirefoxDriver.getFirefoxOptions(desiredCapabilities).addCapabilities(desiredCapabilities).addCapabilities(requiredCapabilities));
        this.warnAboutDeprecatedConstructor("Capabilities", "addCapabilities(capabilities)");
    }

    @Deprecated
    public FirefoxDriver(FirefoxBinary binary, FirefoxProfile profile, Capabilities capabilities) {
        this(FirefoxDriver.getFirefoxOptions(capabilities).setBinary(binary).setProfile(profile).addCapabilities(capabilities));
        this.warnAboutDeprecatedConstructor("FirefoxBinary, FirefoxProfile, Capabilities", "setBinary(binary).setProfile(profile).addCapabilities(capabilities)");
    }

    @Deprecated
    public FirefoxDriver(FirefoxBinary binary, FirefoxProfile profile, Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        this(FirefoxDriver.getFirefoxOptions(desiredCapabilities).setBinary(binary).setProfile(profile).addCapabilities(desiredCapabilities).addCapabilities(requiredCapabilities));
        this.warnAboutDeprecatedConstructor("FirefoxBinary, FirefoxProfile, Capabilities", "setBinary(binary).setProfile(profile).addCapabilities(capabilities)");
    }

    private FirefoxDriver(CommandExecutor executor, Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        super(executor, FirefoxDriver.dropCapabilities(desiredCapabilities).merge(FirefoxDriver.dropCapabilities(requiredCapabilities)));
    }

    private static CommandExecutor toExecutor(FirefoxOptions options) {
        DriverService.Builder builder = options.isLegacy() ? XpiDriverService.builder().withBinary(options.getBinaryOrNull().orElseGet(FirefoxBinary::new)).withProfile(options.getProfile()) : new GeckoDriverService.Builder().usingFirefoxBinary(options.getBinaryOrNull().orElseGet(FirefoxBinary::new));
        return new DriverCommandExecutor((DriverService)builder.build());
    }

    private static FirefoxOptions getFirefoxOptions(Capabilities capabilities) {
        Object marionette;
        FirefoxOptions options = new FirefoxOptions();
        if (capabilities == null) {
            return options;
        }
        Object rawOptions = capabilities.getCapability("moz:firefoxOptions");
        if (rawOptions != null) {
            if (rawOptions instanceof Map) {
                try {
                    Map map = (Map)rawOptions;
                    rawOptions = FirefoxOptions.fromJsonMap(map);
                }
                catch (IOException e) {
                    throw new WebDriverException(e);
                }
            }
            if (rawOptions != null && !(rawOptions instanceof FirefoxOptions)) {
                throw new WebDriverException("Firefox option was set, but is not a FirefoxOption: " + rawOptions);
            }
            options = (FirefoxOptions)rawOptions;
        }
        if ((marionette = capabilities.getCapability(MARIONETTE)) instanceof Boolean) {
            options.setLegacy((Boolean)marionette == false);
        }
        return options;
    }

    private void warnAboutDeprecatedConstructor(String arguments, String alternative) {
        LOG.warning(String.format("The FirefoxDriver constructor taking %s has been deprecated. Please use the FirefoxDriver(FirefoxOptions) constructor, configuring the FirefoxOptions like this: new FirefoxOptions().%s", arguments, alternative));
    }

    @Override
    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    private static boolean isLegacy(Capabilities desiredCapabilities) {
        Boolean forceMarionette = FirefoxDriver.forceMarionetteFromSystemProperty();
        if (forceMarionette != null) {
            return forceMarionette == false;
        }
        Object marionette = desiredCapabilities.getCapability(MARIONETTE);
        return marionette instanceof Boolean && (Boolean)marionette == false;
    }

    private static Boolean forceMarionetteFromSystemProperty() {
        String useMarionette = System.getProperty("webdriver.firefox.marionette");
        if (useMarionette == null) {
            return null;
        }
        return Boolean.valueOf(useMarionette);
    }

    private static Capabilities dropCapabilities(Capabilities capabilities) {
        DesiredCapabilities caps;
        if (capabilities == null) {
            return new DesiredCapabilities();
        }
        if (FirefoxDriver.isLegacy(capabilities)) {
            HashSet<String> toRemove = Sets.newHashSet(BINARY, PROFILE);
            caps = new DesiredCapabilities(Maps.filterKeys(capabilities.asMap(), key -> !toRemove.contains(key)));
        } else {
            caps = new DesiredCapabilities(capabilities);
        }
        Proxy proxy = Proxy.extractFrom(capabilities);
        if (proxy != null) {
            caps.setCapability("proxy", proxy);
        }
        return caps;
    }

    public static final class SystemProperty {
        public static final String BROWSER_BINARY = "webdriver.firefox.bin";
        public static final String BROWSER_LOGFILE = "webdriver.firefox.logfile";
        public static final String BROWSER_LIBRARY_PATH = "webdriver.firefox.library.path";
        public static final String BROWSER_PROFILE = "webdriver.firefox.profile";
        public static final String DRIVER_XPI_PROPERTY = "webdriver.firefox.driver";
        public static final String DRIVER_USE_MARIONETTE = "webdriver.firefox.marionette";
    }
}

